//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see http://www.gnu.org/licenses/.
//

#ifndef RIPNGINTERFACE_H_
#define RIPNGINTERFACE_H_

namespace RIPng
{

class Interface
{
  public:
    Interface(int intId);
    virtual ~Interface();

  protected:
    int id;                     ///< id of the interface as is in interfaceTable
    bool bPassive;              ///< if interface is passive
    // TODO: bool splitHorizon

  public:
    void passive()   { bPassive = true; }
    void noPassive() { bPassive = false; }
    bool isPassive() { return bPassive; }

    int getId() { return id; }
};

} /* namespace RIPng */

#endif /* RIPNGINTERFACE_H_ */
